" 
" File:    latex-for-vim.vim
" Purpose: LaTeX support (MikTeX) for GVIM (on Win32-systems)
" Version: 0.3
" Author:  Volker Kiefel <volker dot kiefel at freenet dot de>
"
" Documentation of this script may be found in latex-for-vim.pdf, source of
" documentation: latex-for-vim.tex.
"
" For installation, please put this file (latex-for-vim.vim) into the vim 
" plugin-directory
"
" This script adds a menu for LaTeX-related functions for .tex, .bib-files
"
" Usage:
" Latex-for-vim supports entering commands, environments and BibTeX entries.
"
" This script is distributed in the hope that it will be useful,
" but WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
"
" V0.1: initial upload
"
" V0.2: Create LaTeX menu and define mappings also with the `BufCreate' 
"       autocmd-event (August 4, 2004)
"
" V0.3: Support for forward-search (Yap of the MikTeX-distribution) added
"       environment pspicture added (April 2, 2005)
"
" V0.4: Command `Wrfws' (write file for forward-search) command added, 
"       calls the function PrintFileLineno() (April 6, 2005)
"



:function! Standard_map()
   :map!  \"a
   :map!  \"o
   :map!  \"u
   :map!  \"A
   :map!  \"O
   :map!  \"U
   :map!  {\ss}
   :set isk+=58,46
:endfunction

:function! Remove_map()
   :call Standard_map()
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
   :set isk-=58,46
:endfunction

:function! German_map()
   :map!  "a
   :map!  "o
   :map!  "u
   :map!  "A
   :map!  "O
   :map!  "U
   :map!  "s
:endfunction

:function! Bibtex_map()
   :map!  {\"a}
   :map!  {\"o}
   :map!  {\"u}
   :map!  {\"A}
   :map!  {\"O}
   :map!  {\"U}
   :map!  {\ss}
:endfunction

:function! Deutsche_umschreibungen_map()
   :map!  ae
   :map!  Ae
   :map!  oe
   :map!  Oe
   :map!  ue
   :map!  Ue
   :map!  ss
:endfunction

:function! Empty_env()
 :let umgebung = input("Enter environment Name: ")
 :if strlen(umgebung) == 0
   :echo "Environment aborted"
   :return
 :elseif umgebung == "itemize" || umgebung == "enumerate" || umgebung == "citemize"
   :let ausgabe = "\\begin{".umgebung."}\n  \\item \n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "description" 
   :let ausgabe = "\\begin{".umgebung."}\n  \\item[] \n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "minipage"
   :let envoption = input("Enter minipage type for latex209 or latex2e [209, 2e]: ")
   :if envoption == "2e"
     :let ausgabe = "\\begin{".umgebung."}[][][]{}\n\n\\end{".umgebung."}"
   :else
     :let ausgabe = "\\begin{".umgebung."}[]{}\n\n\\end{".umgebung."}"
   :endif
   :put!=ausgabe
 :elseif umgebung == "tabular"
   :let ausgabe = "\\begin{".umgebung."}[]{}\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "columns"
   :let ausgabe = "\\begin{".umgebung."}[]\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "column" || umgebung == "block"
   :let ausgabe = "\\begin{".umgebung."}{}\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "picture"
   :let ausgabe = "\\begin{".umgebung."}()\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "pspicture"
   :let ausgabe = "\\begin{".umgebung."}()()\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "array"
   :let ausgabe = "\\begin{".umgebung."}[]{}[]\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "table" || umgebung == "figure"
   :let ausgabe = "\\begin{".umgebung."}[]\n\n  \\caption[]{}\n  \\label{}\n\\end{".umgebung."}"
   :put!=ausgabe
 :elseif umgebung == "theorem"
   :let ausgabe = "\\begin{".umgebung."}{}[]\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :else
   :let ausgabe = "\\begin{".umgebung."}\n\n\\end{".umgebung."}"
   :put!=ausgabe
 :endif
:endfunction

:function! Plain_env()
 :if visualmode() != "V"
   :echo "No text highlighted linewise"
   :return
 :endif
 :let umgebung = input("Enter environment Name: ")
 :if strlen(umgebung) == 0
   :echo "Environment aborted"
   :return
 :elseif umgebung == "itemize" || umgebung == "enumerate" || umgebung == "citemize"
   :let head = "\\begin{".umgebung."}\n  \\item "
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "description" 
   :let head = "\\begin{".umgebung."}\n  \\item[] "
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "minipage"
   :let envoption = input("Enter minipage type for latex209 or latex2e [209, 2e]: ")
   :if envoption == "2e"
     :let head = "\\begin{".umgebung."}[][][]{}\n"
     :let tail = "\n\\end{".umgebung."}"
   :else
     :let head = "\\begin{".umgebung."}[]{}\n"
     :let tail = "\n\\end{".umgebung."}"
   :endif
 :elseif umgebung == "tabular"
   :let head = "\\begin{".umgebung."}[]{}\n"
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "columns"
   :let head = "\\begin{".umgebung."}[]\n"
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "column" || umgebung == "block"
   :let head = "\\begin{".umgebung."}{}\n"
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "picture"
   :let head = "\\begin{".umgebung."}()\n"
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "pspicture"
   :let head = "\\begin{".umgebung."}()()\n"
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "array"
   :let head = "\\begin{".umgebung."}[]{}[]\n"
   :let tail = "\n\\end{".umgebung."}"
 :elseif umgebung == "table" || umgebung == "figure"
   :let head = "\\begin{".umgebung."}[]\n"
   :let tail = "\n  \\caption[]{}\n  \\label{}\n\\end{".umgebung."}"
 :elseif umgebung == "theorem"
   :let head = "\\begin{".umgebung."}{}[]\n"
   :let tail = "\n\\end{".umgebung."}"
 :else
   :let head = "\\begin{".umgebung."}\n"
   :let tail = "\n\\end{".umgebung."}"
 :endif
 :let @m = tail
 :normal `>
 :normal "mp
 :let @m = head
 :normal `<
 :normal "mP
:endfunction

:function! Empty_com()
 :let befehl = input("Enter command Name: ")
 :if strlen(befehl)==0
   :echo "Command aborted"
   :return
 :elseif befehl == "newcommand" || befehl == "renewcommand"
   :let @m = "\\".befehl."{}[]{}"
   :normal "mPhhhh
 :elseif befehl == "multicolumn" 
   :let @m = "\\".befehl."{}{}{}"
   :normal "mPhhhh
 :elseif befehl == "colorbox" || befehl == "textcolor"
   :let @m = "\\".befehl."{}{}"
   :normal "mPhh
 :elseif befehl == "usepackage" ||
     \   befehl == "foilhead" ||
     \   befehl == "includegraphics"
   :let @m = "\\".befehl."[]{}"
   :normal "mPhh
 :elseif befehl == "verb"
   :let @m = "\\".befehl."++"
   :normal "mP
 :else
   :let @m = "\\".befehl."{}"
   :normal "mP
 :endif
:endfunction

:function! Plain_com()
 :if visualmode() != "v"
   :echo "No text highlighted characterwise"
   :return
 :endif
 :let befehl = input("Enter command Name: ")
 :if strlen(befehl)==0
   :echo "Command aborted"
   :return
 :elseif befehl == "newcommand" || befehl == "renewcommand"
   :let head = "\\".befehl."{}[]{"
   :let tail == "}"
 :elseif befehl == "multicolumn" 
   :let head = "\\".befehl."{}{}{"
   :let tail = "}"
 :elseif befehl == "colorbox" || befehl == "textcolor"
   :let head = "\\".befehl."{}{"
   :let tail = "}"
 :elseif befehl == "usepackage" ||
     \   befehl == "foilhead" ||
     \   befehl == "includegraphics"
   :let head = "\\".befehl."[]{"
   :let tail = "}"
 :elseif befehl == "$"
   :let head = "$"
   :let tail = "$"
 :elseif befehl == "\"`"
   :let head = "\"`"
   :let tail = "\"'"
 :elseif befehl == "``"
   :let head = "``"
   :let tail = "''"
 :elseif befehl == "verb"
   :let head = "\\".befehl."+"
   :let tail = "+"
 :else
   :let head = "\\".befehl."{"
   :let tail = "}"
 :endif
 :let @m = tail
 :normal `>
 :normal "mp
 :let @m = head
 :normal `<
 :normal "mP
:endfunction

:function! LatexUnMenu()
  unmenu &LaTeX
:endfunction

:function! LatexMenu()
menu 8000.10.010 &LaTeX.BibTeXE&ntry.&Article        i@article{,<cr>author = {},<cr>title = {},<cr>year = {},<cr>journal = {},<cr>OPTpages = {},<cr>OPTvolume = {},<cr>OPTmonth = {},<cr>OPTnumber = {}<cr>}<cr>
menu 8000.10.020 &LaTeX.BibTeXE&ntry.B&ook           i@book{,<cr>ALTauthor = {},<cr>ALTeditor = {},<cr>title = {},<cr>year = {},<cr>publisher = {},<cr>OPTaddress = {},<cr>OPTedition = {}<cr>}<cr>
menu 8000.10.020 &LaTeX.BibTeXE&ntry.Bookle&t        i@booklet{,<cr>ALTauthor = {},<cr>title = {},<cr>OPThowpublished = {},<cr>OPTaddress = {},<cr>OPTyear = {},<cr>OPTmonth = {}<cr>}<cr>
menu 8000.10.030 &LaTeX.BibTeXE&ntry.I&nbook         i@inbook{,<cr>ALTauthor = {},<cr>ALTeditor = {},<cr>title = {},<cr>OPTtype = {},<cr>year = {},<cr>publisher = {},<cr>OPTaddress = {},<cr>ALTpages = {},<cr>ALTchapter = {},<cr>OPTedition = {}<cr>}<cr>
menu 8000.10.040 &LaTeX.BibTeXE&ntry.&Incollection   i@incollection{,<cr>author = {},<cr>OPTeditor = {},<cr>title = {},<cr>booktitle = {},<cr>year = {},<cr>publisher = {},<cr>OPTpages = {},<cr>OPTaddress = {},<cr>OPTedition = {}<cr>}<cr>
menu 8000.10.050 &LaTeX.BibTeXE&ntry.Inproce&edings  i@inproceedings{,<cr>author = {},<cr>title = {},<cr>booktitle = {},<cr>year = {},<cr>OPTeditor = {},<cr>OPTvolume = {},<cr>OPTnumber = {},<cr>OPTnumber = {},<cr>OPTseries = {},<cr>OPTpages = {},<cr>OPTaddress = {},<cr>OPTmonth = {},<cr>OPTorganization = {},<cr>OPTpublisher = {},<cr>OPTnote = {}<cr>}<cr>
menu 8000.10.060 &LaTeX.BibTeXE&ntry.Manua&l         i@manual{,<cr>title = {},<cr>OPTauthor = {},<cr>OPTorganization = {},<cr>OPTaddress = {},<cr>OPTedition = {},<cr>OPTmonth = {},<cr>OPTyear = {},<cr>OPTnote = {}<cr>}<cr>
menu 8000.10.070 &LaTeX.BibTeXE&ntry.Masterst&hesis  i@mastersthesis{,<cr>author = {},<cr>title = {},<cr>school = {},<cr>year = {},<cr>OPTtype = {},<cr>OPTaddress = {},<cr>OPTmonth = {},<cr>OPTnote = {}<cr>}<cr>
menu 8000.10.080 &LaTeX.BibTeXE&ntry.Mi&sc           i@misc{,<cr>OPTauthor = {},<cr>OPTtitle = {},<cr>OPThowpublished = {},<cr>OPTmonth = {},<cr>OPTyear = {},<cr>OPTnote = {}<cr>}<cr>
menu 8000.10.090 &LaTeX.BibTeXE&ntry.&Phdthesis      i@phdthesis{,<cr>author = {},<cr>title = {},<cr>school = {},<cr>year = {},<cr>OPTtype = {},<cr>OPTaddress = {},<cr>OPTmonth = {},<cr>OPTnote = {}<cr>}<cr>
menu 8000.10.100 &LaTeX.BibTeXE&ntry.P&roceedings    i@proceedings{,<cr>title = {},<cr>year = {},<cr>OPTeditor = {},<cr>OPTvolume = {},<cr>OPTnumber = {},<cr>OPTseries = {},<cr>OPTaddress = {},<cr>OPTpublisher = {},<cr>OPTnote = {}<cr>OPTmonth = {},<cr>OPTmonth = {},<cr>OPTorganization = {}<cr>}<cr>
menu 8000.10.110 &LaTeX.BibTeXE&ntry.Te&chreport     i@techreport{,<cr>title = {},<cr>author = {},<cr>institution = {},<cr>year = {},<cr>OPTtype = {},<cr>OPTnumber = {},<cr>OPTaddress = {},<cr>OPTmonth = {},<cr>OPTnote = {}<cr>}<cr>
menu 8000.10.120 &LaTeX.BibTeXE&ntry.&Unpublished    i@unpublished{,<cr>author = {},<cr>title = {},<cr>OPTmonth = {},<cr>OPTyear = {},<cr>note = {}<cr>}<cr>
menu 8000.10.900 &LaTeX.-sep1-                       <nul>
vmenu 8000.20     &LaTeX.&Environment\ on\ Region<tab>,ren    <Esc> :call Plain_env()<cr>
nmenu 8000.22     &LaTeX.Empty\ &Environment<tab>,en          :call Empty_env()<cr>
vmenu 8000.25     &LaTeX.&Commands\ on\ Region<tab>,rcm       <Esc> :call Plain_com()<cr>
nmenu 8000.25     &LaTeX.Empty\ &Commands<tab>,cm             :call Empty_com()<cr>
menu 8000.30.010 &LaTeX.-sep3-                       <nul>
menu 8000.40.020 &LaTeX.&Umlaute.Normal\ &TeX        :call Standard_map()<cr>
menu 8000.40.030 &LaTeX.&Umlaute.&No\ mapping        :call Remove_map()<cr>
menu 8000.40.040 &LaTeX.&Umlaute.&German\ TeX\ mapping    :call German_map()<cr>
menu 8000.40.050 &LaTeX.&Umlaute.&BibTeX\ mapping    :call Bibtex_map()<cr>
menu 8000.40.070 &LaTeX.&Umlaute.German\ &Umlaut\ mapping   :call Deutsche_umschreibungen_map()<cr>
endfunction

:function! LatexUnMap()
  vunmap ,ren
  unmap ,en
  vunmap ,rcm
  unmap ,cm
:endfunction


:function! LatexMap()
  vmap ,ren  <Esc> :call Plain_env()<cr>
  map ,en   :call Empty_env()<cr>
  vmap ,rcm  <Esc> :call Plain_com()<cr>
  map ,cm   :call Empty_com()<cr>
:endfunction

"
" Support of forward search for Yap (MikTeX):
" The following 10 lines are intended for use of this script
" with Ltxshell (cf http://sourceforge.net/projects/ltxshell).
" If you do not use ltxshell leave these next 10 lines commented out.
" Name and location of `c:\util\ltxshelldvi.txt' may be changed.
"
":function PrintFileLineno()
"  redir! > c:\util\ltxshelldvi.txt
"  silent echo expand("%")
"  silent echo line(".")
"  redir END
":endfunction
"au BufWritePre *.tex :call PrintFileLineno()
"command Wrfws call PrintFileLineno()
"

set timeoutlen=2500
:au BufEnter *.tex,*.dtx,*.ltx,*.bib :call LatexMenu()
:au BufCreate *.tex,*.dtx,*.ltx,*.bib :call LatexMenu()
:au BufLeave *.tex,*.dtx,*.ltx,*.bib :call LatexUnMenu()
:au BufEnter *.tex,*.dtx,*.ltx,*.bib :call LatexMap()
:au BufCreate *.tex,*.dtx,*.ltx,*.bib :call LatexMap()
:au BufLeave *.tex,*.dtx,*.ltx,*.bib :call LatexUnMap()
" :au BufEnter *.tex,*.dtx,*.ltx :call Standard_map()
" :au BufLeave *.tex,*.dtx,*.ltx :call Remove_map()
:au BufEnter *.bib :call Bibtex_map()
:au BufLeave *.bib :call Remove_map()
:au BufEnter *.tex,*.dtx,*.ltx :set isk+=58,46
:au BufLeave *.tex,*.dtx,*.ltx :set isk-=58,46


" vim:tw=2048 encoding=latin1
