" 
" File:    html-for-vim.vim
" Purpose: HTML support for GVIM (on Win32-systems)
" Version: 0.2
" Author:  Volker Kiefel <volker dot kiefel at freenet dot de>
"
" Installation: 
" Please put this file (html-for-vim.vim) into the vim plugin-directory.
" Put the awk-scripts comment-html.awk/uncomment-html.awk into a directory 
" of your choice and adjust the path to these scipts in the appropriate 
" lines of the function HTMLMenu(). Make sure that an awk interpreter is 
" available on your system. An awk program compiled for win32-systems may be
" found on 'http://people.freenet.de/vkiefel/compiled-SW.html'
"
" This script adds a menu for html-related functions for .html-files
"
" Usage:
" html-for-vim supports entering tags and allows to comment/uncomment regions.
"
" This script is distributed in the hope that it will be useful,
" but WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
"
" V0.1: initial upload
"
" V0.2: description of installation completed, call to `gawk' changed to `awk'
"       in function HTMLMenu()
"


:function! Remove_map()
   :call Standard_map()
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
   :unmap! 
:endfunction


:function! Html_map()
   :map!  &auml;
   :map!  &Auml;
   :map!  &ouml;
   :map!  &Ouml;
   :map!  &uuml;
   :map!  &Uuml;
   :map!  &szlig;
:endfunction

:function! Deutsche_umschreibungen_map()
   :map!  ae
   :map!  Ae
   :map!  oe
   :map!  Oe
   :map!  ue
   :map!  Ue
   :map!  ss
:endfunction

:function Plain_tags()
 :if visualmode() != "v"
   :echo "No text highlighted characterwise"
   :return
 :endif
 :let htmltag = input("Enter tag name: ")
 :if strlen(htmltag)==0
   :echo "Tag aborted"
   :return
 :endif
 :let head = "<".htmltag.">"
 :let tail = "</".htmltag.">"
 :let @m = tail
 :normal `>
 :normal "mp
 :let @m = head
 :normal `<
 :normal "mP
:endfunction

:function! Empty_tags()
  :let htmltag = input("Enter tag name: ")
  :if htmltag == "br" || "Br" || "BR"
    :let @m = "<".htmltag.">"
    :normal "mp
  :else
    :let @m = "<".htmltag."></".htmltag.">"
    :normal "mP
  :endif
:endfunction

:function! HTMLUnMenu()
  unmenu HTML
:endfunction

:function! HTMLMenu()
menu 8000.10.030 HTM&L.&Umlaute.&No\ mapping           :call Remove_map()<cr>
menu 8000.10.060 HTM&L.&Umlaute.&HTML\ mapping         :call Html_map()<cr>
menu 8000.10.070 HTM&L.&Umlaute.German\ &Umlaut\ mapping   :call Deutsche_umschreibungen_map()<cr>
nmenu 8000.20.010 HTM&L.Empty\ &Tags                   :call Empty_tags()<cr>
vmenu 8000.20.015 HTM&L.&Tags\ on\ Region        <Esc> :call Plain_tags()<cr>
vmenu 8000.30.010 HTM&L.&Comment.&Comment-Region       :!awk -f c:/vim_scr/comment-html.awk<cr>
vmenu 8000.30.020 HTM&L.&Comment.&Uncomment-Region     :!awk -f c:/vim_scr/uncomment-html.awk<cr>
endfunction


:au BufEnter *.htm,*.html :call HTMLMenu()
:au BufLeave *.htm,*.html :call HTMLUnMenu()
:au BufLeave *.bib :call Remove_map()
:au BufEnter *.html,*.htm :call Html_map()
:au BufLeave *.html,*.htm :call Remove_map()

" vim:encoding=latin-1 tw=2048

