#
#   HLASpec -- Analysis of HLA Antibody-Specificity v1.4
#   Copyright (C) 2003  Volker Kiefel
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#   USA
#
#

BEGIN {
  if (dateien=="")
  {
     print "\nAufruf mit:\n\n  gawk -f hlaspec.awk -v dateien=<name> -v erweitert=[0,1]\n"
     exit(1)
  }
  initialize()
  selbst_definierte_ag = selbst_definierte_ag_expandieren(selbst_definierte_ag)
  if (verify() == 0)
  {
     exit(1)
  }
  read_panel()
  rechnen(anzahl_spalten-1)
}


function initialize()
{
  panel[1,1]= ""            # Antigene der Zellen des Panels [Zelle,AG-Nr]
  paneln[1]=0               # Anzahl der Antigene pro Zelle
  panel_field[1]=""         # Name des Feldes, in das eine Zelle bei Analyse
                            # von UD eingeordnet wird
  panel_geschriebene_antigene[1]="" 
                            # Namen  der Antigene, so wie sie eingetragen
                            # wurden
  ergebnis[1] = 0           # LCT-Ergebnisse im Test
  anzahl_spalten = 0        # ...beim Einlesen der Ergebnisse (Anzahl der
                            #  untersuchten Patienten + 1 [fuer die Spalte mit
                            #  den Zellnummern])
  patient_name = ""         # Name des Patienten in der Ergebnisdatei
  zellname[1] = ""          # Name der Zelle in der ersten Spalte beider
                            # Textdateien
  threshold_string = "Schwelle:" # Schluesselwort fuer Eingabe Schwellenwert
                                 # LCT-Score
  ud_ags = "Antigengruppe:"      # Schluesselwort User-defined antigens
  einzelauswertungs_nummer = "Einzelauswertung:"
                                 # Schluesselwort: Serum, zu dem
                                 # Einzelauswerung erfolgen soll (String)
  auszuwertendes_serum = 0       # ... Einzelauswertung (Zahl)
  anzahl_zellen = 0
  panel_datei_name = dateien ".PAN"
  resultat_datei_name = dateien ".RES"
  ausgabe_datei_name = dateien ".TXT"
  cfg_datei_name = "hlaspec.cfg"
  schwelle = 4
  selbst_definierte_ag = ""
  selbst_definierte_ag_zur_anzeige = ""
  extended_analysis = 0
  if (erweitert==1)
  {
     extended_analysis = 1
  } else
  {
     extended_analysis = 0
  }
  agn_rn = 0; agn_rp = 0; agp_rn = 0; agp_rp = 0;
  
  hlaa = " A1 A2 A3 A9 A23 A24 A10 A25 A26 A34 A66 A11 A19 A29 A30 A31 A32 A33 A74 A28 A68 A69 A36 A43 A80 "
  hlab = " B5 B51 B52 B7 B8 B12 B44 B45 B13 B14 B64 B65 B15 B62 B63 B75 B76 B77 B16 B38 B39 B17 B57 B58 B18 B21 B49 B50 B22 B54 B55 B56 B27 B35 B37 B40 B60 B61 B41 B42 B46 B47 B48 B53 B59 B67 B70 B71 B72 B73 B78 B81 "
  hlac = " Cw1 Cw2 Cw3 Cw9 Cw10 Cw4 Cw5 Cw6 Cw7 Cw8 Cw12 Cw17 "
  hla_cregs = " 1C 2C 28C 5C 12C 7C 22C 8C "
  ag_auszuwerten = hlaa hlab hlac hla_cregs
  cfg_datei_lesen()
  
  if (extended_analysis==1)
  {
     ag_auszuwerten = ag_auszuwerten " p01 p02 p03 p11 p12 p21 p22 p31 p32 p41 p42 p43 p51 p52 p61 p62 p63 p64 p71 p72 p81 p82 p91 p92 p93 p94 p95 g3031 g2532 g311 g1126 g722 g727 g740 g1340 g1213 g1221 g814 g1517 g217 g1622 Bw4 Bw6" 
  }
  if (length(selbst_definierte_ag) > 0)
  {
    ag_auszuwerten = ag_auszuwerten " UD "
  }
  creg_1C = "A1 A3 A9 A23 A24 A10 A25 A26 A34 A66 A11 A28 A68 A69 A29 A30 A31 A32 A33 A43"
  creg_2C = "A2 A28 A68 A69 A9 A23 A24 B17"
  creg_28C = "A28 A68 A69 A33 A34 A26"
  creg_5C = "B5 B51 B52 B53 B35 B18 B70 B71 B72 B15 B62 B63 B75 B76 B77 B17 B57 B58"
  creg_12C = "B12 B44 B45 B21 B49 B50 B40 B60 B61 B13 B41" 
  creg_7C = "B7 B22 B54 B55 B56 B40 B60 B61 B13 B42 B47 B48"
  creg_22C = "B22 B54 B55 B56 B16 B67 B42"
  creg_8C = "B8 B14 B64 B65 B18 B59 B16 B38 B39 B51"
  
  if (extended_analysis==1)
  {
    p01 = "A1 A3 A11 A36"
    p02 = "A2 A28 A68 A69"
    p03 = "A25 A32 A33 A66"
    p11 = "A1 A3 A10 A11 A19 A36 A25 A26 A29 A30 A31 A32 A33 A34 A66 A74"
    p12 = "A2 A9 A28 A23 A24 A68 A69"
    p21 = "A1 A9 A11 A23 A24 A25 A26"
    p22 = "A2 A3 A28 A30 A31 A32 A68 A69"
    p31 = "A26 A28 A33 A34 A68 A69 A74"
    p32 = "A1 A2 A9 A23 A24 A28 A68 A69"
    p41 = "B5 B15 B17 B18 B21 B35 B53 B70 B49 B50 B51 B52 B57 B58 B62 B63 B71 B72 B75 B76 B77"
    p42 = "B7 B22 B27 B40 B41 B42 B46 B47 B48 B73 B54 B55 B56 B60 B61"
    p43 = "B8 B14 B16 B38 B39 B59 B64 B65 B67"
    p51 = "B5 B15 B18 B35 B53 B51 B52 B62 B63 B75 B76 B77"
    p52 = "B13 B27 B40 B41 B47 B60 B61"
    p61 = "B5 B35 B53 B51 B52"
    p62 = "B7 B22 B27 B42 B54 B55 B56"
    p63 = "B8 B14 B18 B59 B64 B65"
    p64 = "B12 B21 B40 B44 B45 B49 B50 B60 B61"
    p71 = "A1 A3 A9 A11 A23 A24 A25 A26" 
    p72 = "B12 B13 B17 B21 B27 B37 B38 B40 B47 B51 B63 B44 B45 B49 B50 B57 B58 B60 B61"
    # p81 enthaelt Bw4
    p81 = "A9 A23 A24 A32 B5 B13 B17 B27 B37 B38 B44 B47 B49 B51 B52 B53 B57 B58  B59 B63 B77"
    p82 = "B12 B13 B21 B27 B37 B40 B47 B41 B44 B45 B49 B50 B60 B61"
    p91 = "A1 A11 A32 A25 A26"
    p92 = "B8 B14 B18 B51 B59 B64 B65"
    p93 = "A1 A3 A10 A11 A19 A28 A36 A25 A26 A29 A30 A31 A32 A33 A34 A66 A68 A69 A74"
    # p94 enthaelt A11 und Bw6
    p94 = "A11 B7 B8 B14 B18 B22 B35 B39 B40 B41 B42 B45 B46 B48 B50 B54 B55 B56 B60 B61 B62 B64 B65 B67 B70 B71 B72 B73 B75 B76 B78 B81"
    p95 = "B8 B14 B16 B22 B38 B39 B54 B55 B56 B64 B65 B67"
    g3031 = "A30 A31" 
    g2532 = "A25 A32"
    g311  = "A3 A11"
    g1126 = "A11 A26"
    g722  = "B7 B22 B54 B55 B56"
    g727  = "B7 B27"
    g740  = "B7 B40 B60 B61"
    g1340 = "B13 B40 B60 B61"
    g1213 = "B12 B13 B44 B45"
    g1221 = "B12 B21 B44 B45 B49 B50"
    g814  = "B8 B14 B64 B65"
    g1517 = "B15 B17 B57 B58 B62 B63 B70 B71 B72 B75 B76 B77"
    g217  = "A2 B17 B57 B58"
    g1622 = "B16 B22 B38 B39 B54 B55 B56 B67"
    Bw4 = "A9 A23 A24 A32 B5 B13 B17 B27 B37 B38 B44 B47 B49 B51 B52 B53 B57 B58  B59 B63 B77"
    Bw6 =  "B7 B8 B14 B18 B22 B35 B39 B40 B41 B42 B45 B46 B48 B50 B54 B55 B56 B60 B61 B62 B64 B65 B67 B70 B71 B72 B73 B75 B76 B78 B81"
  }
  
}

# reads the text file with test cells, splits each line into fields, writes
# fields into the panel array, the number of antigens listed for each cell is
# entered into the 'paneln' array.

function read_panel(    i, j, zeile,ex_arr) 
{
   i = 0; j = 0
   while ((getline zeile < panel_datei_name) > 0 )
   {
      i++
      anzahl_zellen = i
      paneln[i]=split(zeile,ex_arr)-1
      if (paneln[i] < 1)
      {
         break
      }
      zellname[i] = ex_arr[1]
      
      panel_geschriebene_antigene[i] = zeile
      
      zeile = antigene_ergaenzen(ex_arr,zeile,i)
      paneln[i]=split(zeile,ex_arr)-1
      for (j=1;j<=paneln[i];j++)
      {
         panel[i,j] = ex_arr[j+1] # omit first field with cell number!
      }
   }
   close(panel_datei_name)
}

function antigene_ergaenzen(arr,zle,zelle_nr,   j,ausgabe_zeile)
{
   ausgabe_zeile = zle
   for (j=2;j<=(paneln[zelle_nr]+1);j++)
   {
      if ((arr[j]=="A23") || (arr[j]=="A24")) {
        ausgabe_zeile = ausgabe_zeile " A9"
      }
      if ((arr[j]=="A25") || (arr[j]=="A26") || (arr[j]=="A34") || (arr[j]=="A66"))  {
        ausgabe_zeile = ausgabe_zeile " A10"
      }
      if ((arr[j]=="A29") || (arr[j]=="A30") || (arr[j]=="A31") || (arr[j]=="A32") || (arr[j]=="A33") || (arr[j]=="A74")) {
        ausgabe_zeile = ausgabe_zeile " A19"
      }
      if ((arr[j]=="A68") || (arr[j]=="A69")) {
        ausgabe_zeile = ausgabe_zeile " A28"
      }
      if ((arr[j]=="Cw9") || (arr[j]=="Cw10")) {
        ausgabe_zeile = ausgabe_zeile " Cw3"
      }
      if ((arr[j]=="B51") || (arr[j]=="B52")) {
        ausgabe_zeile = ausgabe_zeile " B5"
      }
      if ((arr[j]=="B44") || (arr[j]=="B45")) {
        ausgabe_zeile = ausgabe_zeile " B12"
      }
      if ((arr[j]=="B64") || (arr[j]=="B65")) {
        ausgabe_zeile = ausgabe_zeile " B14"
      }
      if ((arr[j]=="B62") || (arr[j]=="B63") || (arr[j]=="B75") || (arr[j]=="B76") || (arr[j]=="B77")) {
        ausgabe_zeile = ausgabe_zeile " B15"
      }
      if ((arr[j]=="B38") || (arr[j]=="B39")) {
        ausgabe_zeile = ausgabe_zeile " B16"
      }
      if ((arr[j]=="B57") || (arr[j]=="B58")) {
        ausgabe_zeile = ausgabe_zeile " B17"
      }
      if ((arr[j]=="B49") || (arr[j]=="B50")) {
        ausgabe_zeile = ausgabe_zeile " B21"
      }
      if ((arr[j]=="B54") || (arr[j]=="B55") || (arr[j]=="B56")) {
        ausgabe_zeile = ausgabe_zeile " B22"
      }
      if ((arr[j]=="B60") || (arr[j]=="B61")) {
        ausgabe_zeile = ausgabe_zeile " B40"
      }
      if ((arr[j]=="B71") || (arr[j]=="B72")) {
        ausgabe_zeile = ausgabe_zeile " B70"
      }
      # if ((arr[j]=="Cw9") || (arr[j]=="Cw10")) {
      #   ausgabe_zeile = ausgabe_zeile " Cw3"
      # }
      if (is_in_antigenlist(arr[j], creg_1C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 1C"
      }
      if (is_in_antigenlist(arr[j], creg_2C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 2C"
      }
      if (is_in_antigenlist(arr[j], creg_28C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 28C"
      }
      if (is_in_antigenlist(arr[j], creg_5C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 5C"
      }
      if (is_in_antigenlist(arr[j], creg_12C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 12C"
      }
      if (is_in_antigenlist(arr[j], creg_7C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 7C"
      }
      if (is_in_antigenlist(arr[j], creg_22C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 22C"
      }
      if (is_in_antigenlist(arr[j], creg_8C) == 1) {
        ausgabe_zeile = ausgabe_zeile " 8C"
      }
      if (is_in_antigenlist(arr[j], selbst_definierte_ag) == 1) {
        ausgabe_zeile = ausgabe_zeile " UD"
      }
      if (extended_analysis == 1)
      {
         if (is_in_antigenlist(arr[j], p01) == 1) {
           ausgabe_zeile = ausgabe_zeile " p01"
         }
         if (is_in_antigenlist(arr[j], p02) == 1) {
           ausgabe_zeile = ausgabe_zeile " p02"
         }
         if (is_in_antigenlist(arr[j], p03) == 1) {
           ausgabe_zeile = ausgabe_zeile " p03"
         }
         if (is_in_antigenlist(arr[j], p11) == 1) {
           ausgabe_zeile = ausgabe_zeile " p11"
         }
         if (is_in_antigenlist(arr[j], p12) == 1) {
           ausgabe_zeile = ausgabe_zeile " p12"
         }
         if (is_in_antigenlist(arr[j], p21) == 1) {
           ausgabe_zeile = ausgabe_zeile " p21"
         }
         if (is_in_antigenlist(arr[j], p22) == 1) {
           ausgabe_zeile = ausgabe_zeile " p22"
         }
         if (is_in_antigenlist(arr[j], p31) == 1) {
           ausgabe_zeile = ausgabe_zeile " p31"
         }
         if (is_in_antigenlist(arr[j], p32) == 1) {
           ausgabe_zeile = ausgabe_zeile " p32"
         }
         if (is_in_antigenlist(arr[j], p41) == 1) {
           ausgabe_zeile = ausgabe_zeile " p41"
         }
         if (is_in_antigenlist(arr[j], p42) == 1) {
           ausgabe_zeile = ausgabe_zeile " p42"
         }
         if (is_in_antigenlist(arr[j], p43) == 1) {
           ausgabe_zeile = ausgabe_zeile " p43"
         }
         if (is_in_antigenlist(arr[j], p51) == 1) {
           ausgabe_zeile = ausgabe_zeile " p51"
         }
         if (is_in_antigenlist(arr[j], p52) == 1) {
           ausgabe_zeile = ausgabe_zeile " p52"
         }
         if (is_in_antigenlist(arr[j], p61) == 1) {
           ausgabe_zeile = ausgabe_zeile " p61"
         }
         if (is_in_antigenlist(arr[j], p62) == 1) {
           ausgabe_zeile = ausgabe_zeile " p62"
         }
         if (is_in_antigenlist(arr[j], p63) == 1) {
           ausgabe_zeile = ausgabe_zeile " p63"
         }
         if (is_in_antigenlist(arr[j], p64) == 1) {
           ausgabe_zeile = ausgabe_zeile " p64"
         }
         if (is_in_antigenlist(arr[j], p71) == 1) {
           ausgabe_zeile = ausgabe_zeile " p71"
         }
         if (is_in_antigenlist(arr[j], p72) == 1) {
           ausgabe_zeile = ausgabe_zeile " p72"
         }
         if (is_in_antigenlist(arr[j], p81) == 1) {
           ausgabe_zeile = ausgabe_zeile " p81"
         }
         if (is_in_antigenlist(arr[j], p82) == 1) {
           ausgabe_zeile = ausgabe_zeile " p82"
         }
         if (is_in_antigenlist(arr[j], p91) == 1) {
           ausgabe_zeile = ausgabe_zeile " p91"
         }
         if (is_in_antigenlist(arr[j], p92) == 1) {
           ausgabe_zeile = ausgabe_zeile " p92"
         }
         if (is_in_antigenlist(arr[j], p93) == 1) {
           ausgabe_zeile = ausgabe_zeile " p93"
         }
         if (is_in_antigenlist(arr[j], p94) == 1) {
           ausgabe_zeile = ausgabe_zeile " p94"
         }
         if (is_in_antigenlist(arr[j], p95) == 1) {
           ausgabe_zeile = ausgabe_zeile " p95"
         }
         if (is_in_antigenlist(arr[j], g3031) == 1) {
           ausgabe_zeile = ausgabe_zeile " g3031"
         }
         if (is_in_antigenlist(arr[j], g2532) == 1) {
           ausgabe_zeile = ausgabe_zeile " g2532"
         }
         if (is_in_antigenlist(arr[j], g311) == 1) {
           ausgabe_zeile = ausgabe_zeile " g311"
         }
         if (is_in_antigenlist(arr[j], g1126) == 1) {
           ausgabe_zeile = ausgabe_zeile " g1126"
         }
         if (is_in_antigenlist(arr[j], g722) == 1) {
           ausgabe_zeile = ausgabe_zeile " g722"
         }
         if (is_in_antigenlist(arr[j], g727) == 1) {
           ausgabe_zeile = ausgabe_zeile " g727"
         }
         if (is_in_antigenlist(arr[j], g740) == 1) {
           ausgabe_zeile = ausgabe_zeile " g740"
         }
         if (is_in_antigenlist(arr[j], g1340) == 1) {
           ausgabe_zeile = ausgabe_zeile " g1340"
         }
         if (is_in_antigenlist(arr[j], g1213) == 1) {
           ausgabe_zeile = ausgabe_zeile " g1213"
         }
         if (is_in_antigenlist(arr[j], g1221) == 1) {
           ausgabe_zeile = ausgabe_zeile " g1221"
         }
         if (is_in_antigenlist(arr[j], g814) == 1) {
           ausgabe_zeile = ausgabe_zeile " g814"
         }
         if (is_in_antigenlist(arr[j], g1517) == 1) {
           ausgabe_zeile = ausgabe_zeile " g1517"
         }
         if (is_in_antigenlist(arr[j], g217) == 1) {
           ausgabe_zeile = ausgabe_zeile " g217"
         }
         if (is_in_antigenlist(arr[j], g1622) == 1) {
           ausgabe_zeile = ausgabe_zeile " g1622"
         }
         if (is_in_antigenlist(arr[j], Bw4) == 1) {
           ausgabe_zeile = ausgabe_zeile " Bw4"
         }
         if (is_in_antigenlist(arr[j], Bw6) == 1) {
           ausgabe_zeile = ausgabe_zeile " Bw6"
         }
      }
        
   }
   return ausgabe_zeile;
}

function read_result(position,   zeile, ex_arr,i,anz)
{
  i = 0

  while ((getline zeile < resultat_datei_name) > 0 )
  {
     i++
     if (i==(position-1))  # first name is in first line
     {
       patient_name = zeile
       printf ("\nPatient: %s\n", patient_name)
     }
     if (index(zeile,":")==1)
     {
       break
     }
  }
  i = 1
  while ((getline zeile < resultat_datei_name) > 0 )
  {
      i++
      anz = split(zeile,ex_arr)
      ergebnis[i-1] = ex_arr[position] # first result is in second column 
  }
  close(resultat_datei_name)
}

function count_fourfold_tables(antigenliste,zelle,     ex_arr,anzahl_ag,i,j,ag_name,k,ok,kommentar,ntotal,npositiv)
{
   anzahl_ag = split(antigenliste,ex_arr) 
   # zaehlen
   # Scan antigens to be evaluated
   printf("\nSerum: %s (%i)\n",patient_name, zelle) >> ausgabe_datei_name
   #                                            a    b    c    d
   printf("%7s %3s %3s %3s %3s %2s %6s ","Ag", "-", "-", "+", "+"," ","   ") >> ausgabe_datei_name
   printf("%7s %3s %3s %3s %3s %2s %6s ","Ag", "-", "-", "+", "+"," ","   ") >> ausgabe_datei_name
   printf("\n") >> ausgabe_datei_name
   printf("%7s %3s %3s %3s %3s %2s %6s;","R ", "-", "+", "-", "+","K","Phi") >> ausgabe_datei_name
   printf("%7s %3s %3s %3s %3s %2s %6s;","R ", "-", "+", "-", "+","K","Phi") >> ausgabe_datei_name
   printf("\n") >> ausgabe_datei_name
   for (i=1;i<=anzahl_ag;i++)
   {
      agn_rn = 0; agn_rp = 0; agp_rn = 0; agp_rp = 0;
      ag_name = ex_arr[i]
      # Scan cells 
      for (j=1; j <= anzahl_zellen; j++)
      {
         if (ergebnis[j]==0)
         {
             # assignment in next line revents warning about reference to
             # uninitialized element using gawk (v3.1.0) --lint
             panel_field[j]=""
             continue
         }
         ok = antigen_is_on_cell(ag_name,j)
         if ((ergebnis[j] < schwelle) && (ok==0)) {
            # field a
            if (ag_name=="UD")
            {
               panel_field[j]="a"
            }
            agn_rn++   ; continue
         }
         if ((ergebnis[j] < schwelle) && (ok==1)) {
            # field c
            if (ag_name=="UD")
            {
               panel_field[j]="c"
            }
            agp_rn++  ; continue 
         }
         if ((ergebnis[j] >= schwelle) && (ok==0)) {
            # field b 
            if (ag_name=="UD")
            {
               panel_field[j]="b"
            }
            agn_rp++ ; continue 
         }
         if ((ergebnis[j] >= schwelle) && (ok==1)) {
            # field d
            if (ag_name=="UD")
            {
               panel_field[j]="d"
            }
            agp_rp++    
         }
      }
      if ((agp_rp >= 2) && (agn_rp == 0) && (agp_rn == 0))
      {
        kommentar = "**"
      }
      else if ((agp_rp >= 2) && (agn_rp >= 0) && (agp_rn == 0))
      {
        kommentar = "*"
      }
      else 
      {
        kommentar = ""
      }
      
      printf("%7s %3i %3i %3i %3i %2s %6s;",ag_name,agn_rn,agn_rp,agp_rn,agp_rp,kommentar,phi_koeff(agn_rn,agn_rp,agp_rn,agp_rp)) >> ausgabe_datei_name
      if (((i % 2)==0) || (i==anzahl_ag))
      {
         printf("\n") >> ausgabe_datei_name
      }
   }
   npositiv = 0
   ntotal = 0
   for (j=1; j <= anzahl_zellen; j++)
   {
      if ((ergebnis[j] >= schwelle)) {
         npositiv++ ; ntotal++ ; continue
      }
      if ((ergebnis[j] < schwelle) && (ergebnis[j] != 0)) {
         ntotal++   ; continue
      }
   }
   printf("%i/%i (%.1f Prozent) Zellen positiv\n",npositiv,ntotal,100*npositiv/ntotal) >> ausgabe_datei_name
   if (length(selbst_definierte_ag) > 0)
   {
      printf("%s: %s\n","UD",selbst_definierte_ag_zur_anzeige) >> ausgabe_datei_name
   }
   printf("Als positiv wurden Scores ab %i gewertet\n",schwelle) >> ausgabe_datei_name
   close(ausgabe_datei_name)   
}

function antigen_is_on_cell(ag, zelle,   i)
{
  for (i=1;i<=paneln[zelle];i++)
  {
      if (panel[zelle,i]==ag)
      {
         return 1
      }
  }
  return 0
}

# 'anzahl': number of columns in results file minus one (cell number)
function rechnen(anzahl, i,j)
{
  # printf("            Reaktion \n") >> ausgabe_datei_name 
  # printf(" Antigen    -      + \n") >> ausgabe_datei_name 
  # printf("   -        a      b \n") >> ausgabe_datei_name
  # printf("   +        c      d \n") >> ausgabe_datei_name
  if ((auszuwertendes_serum == 0) || (auszuwertendes_serum < 1) || (auszuwertendes_serum > (anzahl_spalten - 1)))
  {
     for (i=2;i<=anzahl+1;i++)
     {
        read_result(i)
        count_fourfold_tables(ag_auszuwerten,i-1)
     }
  } else
  {
        read_result(auszuwertendes_serum+1)
        count_fourfold_tables(ag_auszuwerten,auszuwertendes_serum)
        if (length(panel_field[1]) > 0)
        {
           printf("\n\nDetails - Vierfeldertafel: %s",selbst_definierte_ag) >> ausgabe_datei_name
           printf("\n\nFeld a (Ag-/R-):\n") >> ausgabe_datei_name
           for(j=1;j<=anzahl_zellen;j++)
           {
             if (panel_field[j]=="a")
             {
                printf("%s\n",panel_geschriebene_antigene[j]) >> ausgabe_datei_name
             }
           }
           printf("\n\nFeld b (Ag-/R+):\n") >> ausgabe_datei_name
           for(j=1;j<=anzahl_zellen;j++)
           {
             if (panel_field[j]=="b")
             {
                printf("%s\n",panel_geschriebene_antigene[j]) >> ausgabe_datei_name
             }
           }
           printf("\n\nFeld c (Ag+/R-): \n") >> ausgabe_datei_name
           for(j=1;j<=anzahl_zellen;j++)
           {
             if (panel_field[j]=="c")
             {
                printf("%s\n",panel_geschriebene_antigene[j]) >> ausgabe_datei_name
             }
           }
           printf("\n\nFeld d (Ag+/R+): \n") >> ausgabe_datei_name
           for(j=1;j<=anzahl_zellen;j++)
           {
             if (panel_field[j]=="d")
             {
                printf("%s\n",panel_geschriebene_antigene[j]) >> ausgabe_datei_name
             }
           }
           close(ausgabe_datei_name)
        }
  }
}

function verify(   zeile,anz,i,ex_arr)
{
   i = 0
   printf("\nTextdateien werden geprueft...\n")
   while (((getline zeile < resultat_datei_name) > 0 ) && (length(zeile)>0))
   {
      i++
      # begin new v1.3
      if (length(zeile)==0)
      {
         print "\nProblem: bitte Leerzeile (" i ") in Resultatdatei loeschen!"
         exit(1);
      }
      # end new v1.3
      if (index(zeile,":")==1)
      {
         anzahl_spalten = i  # number of patients + 1
         break
      }
   }
   i = 1;
   while (((getline zeile < resultat_datei_name) > 0) && (length(zeile)>0) )
   {
      i++
      # begin new v1.3
      if (length(zeile)==0)
      {
         print "\nProblem: bitte Leerzeile (" i ") in Resultatdatei loeschen!"
         exit(1);
      }
      # end new v1.3
      anzahl_zellen = i-1
      anz=split(zeile,ex_arr)
      if (anz != anzahl_spalten)
      {
         printf("\nProblem: Falsche Anzahl Eintragungen zur %i. Zelle in der Datei `%s'.\n",
           i-1, resultat_datei_name)
         printf("Alle Zeilen muessen die gleiche Anzahl von Eintragungen aufweisen (getrennt\n")
         printf("durch je ein oder mehrere Leerzeichen).\n")
         close(resultat_datei_name)
         return 0
      }
      zellname[i-1] = ex_arr[1]
   }
   close(resultat_datei_name)
   i = 0
   while (((getline zeile < panel_datei_name) > 0) && (length(zeile)>0))
   {
     i++
     # begin new v1.3
     if (length(zeile)==0)
     {
        print "\nProblem: bitte Leerzeile (" i ") in Paneldatei loeschen!"
        exit(1);
     }
     # end new v1.3
     if (i > anzahl_zellen)
     {
        printf("\nProblem: Es finden sich mehr Zellen in `%s' als in `%s'\n",
            panel_datei_name,resultat_datei_name)
        close(panel_datei_name)
        return 0
     }
     split(zeile,ex_arr)
     if (zellname[i] != ex_arr[1])
     {
        printf("\nProblem: Zellname `%s' in Datei `%s', Zeile %i passt nicht zu\nZellname`%s' in  Datei `%s': Zellnamen muessen sich stets entsprechen.\n",
          ex_arr[1],panel_datei_name,i,zellname[i],resultat_datei_name)
        close(panel_datei_name)
        return 0
     }
   }
   close(panel_datei_name)
   return 1
}

# Usage of function: 'is_in_antigenlist("A1", "B7 B27 A10")' returns 0
function is_in_antigenlist(teil, gesamtliste,        antigen_arr,i,anzahl_ag)
{
   anzahl_ag = split(gesamtliste, antigen_arr)
   for (i=1; i <= anzahl_ag; i++)
   {
      if (antigen_arr[i] == teil)
      {
        return 1
      }
   }
   return 0
}

function phi_koeff(a,b,c,d,     twert,resultat)
{
   twert = (a+b)*(c+d)*(a+c)*(b+d)
   if (twert == 0)
   {
      return "n.d."
   }
   else 
   {
      return sprintf("%3.3f",(a*d-b*c)/sqrt(twert))
   }
}

function cfg_datei_lesen(      eing_zeile,ex_zeile,neue_sch)
{
   while ((getline eing_zeile < cfg_datei_name) > 0)
   {
     if ((index(eing_zeile,ud_ags) == 1) && (length(eing_zeile) > length(ud_ags)))
     {
       ex_zeile = substr(eing_zeile,length(ud_ags)+1)
       selbst_definierte_ag = ex_zeile
       selbst_definierte_ag_zur_anzeige = ex_zeile
     }
     if ((index(eing_zeile,threshold_string) == 1) && (length(eing_zeile) > length(threshold_string)))
     {
       neue_sch = substr(eing_zeile,length(threshold_string)+1)
       neue_sch = neue_sch + 0
       if ((neue_sch == 4) || (neue_sch == 8) || (neue_sch == 6))
       {
          schwelle=neue_sch
       } else
       {
          schwelle=6
       }
     }
     if ((index(eing_zeile,einzelauswertungs_nummer) == 1) && (length(eing_zeile) > length(einzelauswertungs_nummer)))
     {
       auszuwertendes_serum = substr(eing_zeile,length(einzelauswertungs_nummer)+1)
       auszuwertendes_serum = auszuwertendes_serum + 0
       if ((auszuwertendes_serum < 1))
       {
           auszuwertendes_serum = 0
       }
     }
   }
   close(cfg_datei_name)
}

function selbst_definierte_ag_expandieren(sda,    ausgabe_zeile,i,n,sda_arr)
{
   ausgabe_zeile = ""
   n = split(sda,sda_arr)
   
   for (i=1;i<=n;i++)
   {
      if (sda_arr[i]=="A9")
      {
        ausgabe_zeile = ausgabe_zeile " A9 A23 A24"
        continue;
      }
      if (sda_arr[i]=="A10")
      {
        ausgabe_zeile = ausgabe_zeile " A10 A25 A26 A34 A66"
        continue;
      }
      if (sda_arr[i]=="A19")
      {
        ausgabe_zeile = ausgabe_zeile " A19 A29 A30 A31 A32 A33 A74"
        continue;
      }
      if (sda_arr[i]=="A28")
      {
        ausgabe_zeile = ausgabe_zeile " A28 A68 A69"
        continue;
      }
      if (sda_arr[i]=="Cw3")
      {
        ausgabe_zeile = ausgabe_zeile " Cw3 Cw9 Cw10"
        continue;
      }
      if (sda_arr[i]=="B5")
      {
        ausgabe_zeile = ausgabe_zeile " B5 B51 B52"
        continue;
      }
      if (sda_arr[i]=="B12")
      {
        ausgabe_zeile = ausgabe_zeile " B12 B44 B45"
        continue;
      }
      if (sda_arr[i]=="B14")
      {
        ausgabe_zeile = ausgabe_zeile " B14 B64 B65"
        continue;
      }
      if (sda_arr[i]=="B15")
      {
        ausgabe_zeile = ausgabe_zeile " B15 B62 B63 B75 B76 B77"
        continue;
      }
      if (sda_arr[i]=="B16")
      {
        ausgabe_zeile = ausgabe_zeile " B16 B38 B39"
        continue;
      }
      if (sda_arr[i]=="B17")
      {
        ausgabe_zeile = ausgabe_zeile " B17 B57 B58"
        continue;
      }
      if (sda_arr[i]=="B21")
      {
        ausgabe_zeile = ausgabe_zeile " B21 B49 B50"
        continue;
      }
      if (sda_arr[i]=="B22")
      {
        ausgabe_zeile = ausgabe_zeile " B22 B54 B55 B56"
        continue;
      }
      if (sda_arr[i]=="B40")
      {
        ausgabe_zeile = ausgabe_zeile " B40 B60 B61"
        continue;
      }
      if (sda_arr[i]=="B70")
      {
        ausgabe_zeile = ausgabe_zeile " B70 B71 B72"
        continue;
      }
      if (sda_arr[i]=="CREG1C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_1C
        continue;
      }
      if (sda_arr[i]=="CREG2C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_2C
        continue;
      }
      if (sda_arr[i]=="CREG28C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_28C
        continue;
      }
      if (sda_arr[i]=="CREG5C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_5C
        continue;
      }
      if (sda_arr[i]=="CREG12C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_12C
        continue;
      }
      if (sda_arr[i]=="CREG7C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_7C
        continue;
      }
      if (sda_arr[i]=="CREG22C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_22C
        continue;
      }
      if (sda_arr[i]=="CREG8C")
      {
        ausgabe_zeile = ausgabe_zeile " " creg_8C
        continue;
      }
      # Erweiterte Fragestellungen
      if ((extended_analysis==1) && (sda_arr[i]=="p01"))
      {
        ausgabe_zeile = ausgabe_zeile " " p01
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p02"))
      {
        ausgabe_zeile = ausgabe_zeile " " p02
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p03"))
      {
        ausgabe_zeile = ausgabe_zeile " " p03
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p11"))
      {
        ausgabe_zeile = ausgabe_zeile " " p11
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p12"))
      {
        ausgabe_zeile = ausgabe_zeile " " p12
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p21"))
      {
        ausgabe_zeile = ausgabe_zeile " " p21
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p22"))
      {
        ausgabe_zeile = ausgabe_zeile " " p22
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p31"))
      {
        ausgabe_zeile = ausgabe_zeile " " p31
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p32"))
      {
        ausgabe_zeile = ausgabe_zeile " " p32
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p41"))
      {
        ausgabe_zeile = ausgabe_zeile " " p41
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p42"))
      {
        ausgabe_zeile = ausgabe_zeile " " p42
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p43"))
      {
        ausgabe_zeile = ausgabe_zeile " " p43
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p51"))
      {
        ausgabe_zeile = ausgabe_zeile " " p51
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p52"))
      {
        ausgabe_zeile = ausgabe_zeile " " p52
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p61"))
      {
        ausgabe_zeile = ausgabe_zeile " " p61
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p62"))
      {
        ausgabe_zeile = ausgabe_zeile " " p62
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p63"))
      {
        ausgabe_zeile = ausgabe_zeile " " p63
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p64"))
      {
        ausgabe_zeile = ausgabe_zeile " " p64
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p71"))
      {
        ausgabe_zeile = ausgabe_zeile " " p71
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p72"))
      {
        ausgabe_zeile = ausgabe_zeile " " p72
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p81"))
      {
        ausgabe_zeile = ausgabe_zeile " " p81
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p82"))
      {
        ausgabe_zeile = ausgabe_zeile " " p82
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p91"))
      {
        ausgabe_zeile = ausgabe_zeile " " p91
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p92"))
      {
        ausgabe_zeile = ausgabe_zeile " " p92
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p93"))
      {
        ausgabe_zeile = ausgabe_zeile " " p93
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p94"))
      {
        ausgabe_zeile = ausgabe_zeile " " p94
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="p95"))
      {
        ausgabe_zeile = ausgabe_zeile " " p95
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g3031"))
      {
        ausgabe_zeile = ausgabe_zeile " " g3031
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g2532"))
      {
        ausgabe_zeile = ausgabe_zeile " " g2532
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g311"))
      {
        ausgabe_zeile = ausgabe_zeile " " g311
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g1126"))
      {
        ausgabe_zeile = ausgabe_zeile " " g1126
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g722"))
      {
        ausgabe_zeile = ausgabe_zeile " " g722
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g727"))
      {
        ausgabe_zeile = ausgabe_zeile " " g727
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g740"))
      {
        ausgabe_zeile = ausgabe_zeile " " g740
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g1340"))
      {
        ausgabe_zeile = ausgabe_zeile " " g1340
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g1213"))
      {
        ausgabe_zeile = ausgabe_zeile " " g1213
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g1221"))
      {
        ausgabe_zeile = ausgabe_zeile " " g1221
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g814"))
      {
        ausgabe_zeile = ausgabe_zeile " " g814
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g1517"))
      {
        ausgabe_zeile = ausgabe_zeile " " g1517
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g217"))
      {
        ausgabe_zeile = ausgabe_zeile " " g217
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="g1622"))
      {
        ausgabe_zeile = ausgabe_zeile " " g1622
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="Bw4"))
      {
        ausgabe_zeile = ausgabe_zeile " " Bw4
        continue;
      }
      if ((extended_analysis==1) && (sda_arr[i]=="Bw6"))
      {
        ausgabe_zeile = ausgabe_zeile " " Bw6
        continue;
      }
      else 
      {
        ausgabe_zeile = ausgabe_zeile " " sda_arr[i]
      } 
   }
   return ausgabe_zeile
}
